/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.keybinds;

import com.moulberry.axiom.configuration.KeybindConfiguration;
import com.moulberry.axiom.editor.keybinds.Keybind;
import com.moulberry.axiom.editor.keybinds.KeybindCategory;
import com.moulberry.axiom.tools.ToolManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Keybinds {
    public static Map<Integer, Set<Keybind>> keybindsForKey = new HashMap<Integer, Set<Keybind>>();
    public static final Keybind ROTATE_CAMERA = new Keybind("rotate_camera", -1, false, false, false, false);
    public static final Keybind PICK_BLOCK = new Keybind("pick_block", -3, false, false, false, false);
    public static final Keybind USE_TOOL = new Keybind("use_tool", -2, false, false, false, false);
    public static final Keybind ARCBALL_CAMERA = new Keybind("arcball_camera", -1, false, true, false, false);
    public static final Keybind ARCBALL_CARDINAL_SNAP = new Keybind("arcball_cardinal_snap", 0, false, false, false, false);
    public static final Keybind PAN_CAMERA = new Keybind("pan_camera", -2, false, true, false, false);
    public static final Keybind CROSSHAIR_CAMERA = new Keybind("crosshair_camera", -2, false, false, false, false);
    public static final Keybind ADJUST_RADIUS = new Keybind("adjust_radius", -3, false, true, false, false);
    public static final Keybind ADJUST_SPEED = new Keybind("adjust_speed", 0, false, false, false, false);
    public static final Keybind UNDO = new Keybind("undo", 90, false, true, false, false);
    public static final Keybind REDO = new Keybind("redo", 89, false, true, false, false);
    public static final Keybind CUT = new Keybind("cut", 88, false, true, false, false);
    public static final Keybind DUPLICATE = new Keybind("duplicate", 74, false, true, false, false);
    public static final Keybind COPY = new Keybind("copy", 67, false, true, false, false);
    public static final Keybind PASTE = new Keybind("paste", 86, false, true, false, false);
    public static final Keybind SAVE_BLUEPRINT = new Keybind("save_blueprint", 80, false, true, false, false);
    public static final Keybind SHOW_SELECTION = new Keybind("show_selection", 0, false, false, false, false);
    public static final Keybind SHOW_BIOMES = new Keybind("show_biomes", 66, false, true, false, false);
    public static final Keybind QUICK_FILL = new Keybind("quick_fill", 70, false, true, false, false);
    public static final Keybind QUICK_REPLACE = new Keybind("quick_replace", 82, false, true, false, false);
    public static final Keybind ROTATE_PLACEMENT = new Keybind("rotate_placement", 82, false, true, false, false);
    public static final Keybind FLIP_PLACEMENT = new Keybind("flip_placement", 70, false, true, false, false);
    public static boolean useVanillaMovement = true;
    public static final Keybind MOVE_QUICK = new Keybind("move_quick", 341, false, false, false, false);
    public static final Keybind MOVE_FORWARD = new Keybind("move_forward", 87, false, false, false, false);
    public static final Keybind MOVE_LEFT = new Keybind("move_left", 65, false, false, false, false);
    public static final Keybind MOVE_BACKWARD = new Keybind("move_backward", 83, false, false, false, false);
    public static final Keybind MOVE_RIGHT = new Keybind("move_right", 68, false, false, false, false);
    public static final Keybind MOVE_UP = new Keybind("move_up", 32, false, false, false, false);
    public static final Keybind MOVE_DOWN = new Keybind("move_down", 340, false, false, false, false);
    public static final Keybind SWAP_TO_LAST_TOOL = new Keybind("swap_to_last_tool", 0, false, false, false, false);
    public static final Keybind COPY_INGAME = new Keybind("copy_ingame", 67, false, true, false, false);
    public static final Keybind NUDGE_UP = new Keybind("nudge_up", 265, false, false, false, false);
    public static final Keybind NUDGE_DOWN = new Keybind("nudge_down", 264, false, false, false, false);
    public static final Keybind NUDGE_RIGHT = new Keybind("nudge_right", 262, false, false, false, false);
    public static final Keybind NUDGE_LEFT = new Keybind("nudge_left", 263, false, false, false, false);
    private static KeybindCategory toolKeybinds = ToolManager.createKeybindCategory();
    public static List<KeybindCategory> categories = List.of(new KeybindCategory("axiom.keybind_categories.basic", true, List.of(ROTATE_CAMERA, PICK_BLOCK, USE_TOOL, ARCBALL_CAMERA, ARCBALL_CARDINAL_SNAP, PAN_CAMERA, CROSSHAIR_CAMERA, ADJUST_RADIUS, ADJUST_SPEED)), new KeybindCategory("axiom.keybind_categories.edit", true, List.of(UNDO, REDO, CUT, DUPLICATE, COPY, PASTE, SAVE_BLUEPRINT)), new KeybindCategory("axiom.keybind_categories.view", true, List.of(SHOW_SELECTION, SHOW_BIOMES)), new KeybindCategory("axiom.keybind_categories.operations", true, List.of(QUICK_FILL, QUICK_REPLACE)), new KeybindCategory("axiom.keybind_categories.placement", true, List.of(ROTATE_PLACEMENT, FLIP_PLACEMENT)), new KeybindCategory("axiom.keybind_categories.movement", false, List.of(MOVE_QUICK, MOVE_FORWARD, MOVE_LEFT, MOVE_BACKWARD, MOVE_RIGHT, MOVE_UP, MOVE_DOWN)), toolKeybinds, new KeybindCategory("axiom.keybind_categories.ingame", false, List.of(COPY_INGAME)), new KeybindCategory("axiom.keybind_categories.gizmo", false, List.of(NUDGE_UP, NUDGE_DOWN, NUDGE_RIGHT, NUDGE_LEFT)));
    public static boolean hasShiftCtrl = false;
    public static boolean hasShiftAlt = false;

    public static void updateMapping(Keybind keybind, int old) {
        if (keybind.isShiftMod() && keybind.isCtrlMod()) {
            hasShiftCtrl = true;
        } else if (categories != null) {
            hasShiftCtrl = false;
            block0: for (KeybindCategory category : categories) {
                for (Keybind other : category.keybinds()) {
                    if (!other.isShiftMod() || !other.isCtrlMod()) continue;
                    hasShiftCtrl = true;
                    break block0;
                }
            }
        }
        if (keybind.isShiftMod() && keybind.isAltMod()) {
            hasShiftAlt = true;
        } else if (categories != null) {
            hasShiftAlt = false;
            block2: for (KeybindCategory category : categories) {
                for (Keybind other : category.keybinds()) {
                    if (!other.isShiftMod() || !other.isAltMod()) continue;
                    hasShiftAlt = true;
                    break block2;
                }
            }
        }
        if (keybind.getKey() == old) {
            return;
        }
        if (old != 0 && keybindsForKey.containsKey(old)) {
            Set<Keybind> set = keybindsForKey.get(old);
            set.remove(keybind);
        }
        if (keybind.getKey() != 0) {
            keybindsForKey.computeIfAbsent(keybind.getKey(), k -> new HashSet()).add(keybind);
        }
    }

    public static void loadFromConfig(KeybindConfiguration keybindConfiguration) {
        ROTATE_CAMERA.loadFromConfigValue(keybindConfiguration.rotateCamera);
        PICK_BLOCK.loadFromConfigValue(keybindConfiguration.pickBlock);
        USE_TOOL.loadFromConfigValue(keybindConfiguration.useTool);
        ARCBALL_CAMERA.loadFromConfigValue(keybindConfiguration.arcballCamera);
        ARCBALL_CARDINAL_SNAP.loadFromConfigValue(keybindConfiguration.arcballCardinalSnap);
        PAN_CAMERA.loadFromConfigValue(keybindConfiguration.panCamera);
        CROSSHAIR_CAMERA.loadFromConfigValue(keybindConfiguration.crosshairCamera);
        ADJUST_RADIUS.loadFromConfigValue(keybindConfiguration.adjustRadius);
        ADJUST_SPEED.loadFromConfigValue(keybindConfiguration.adjustSpeed);
        UNDO.loadFromConfigValue(keybindConfiguration.undo);
        REDO.loadFromConfigValue(keybindConfiguration.redo);
        CUT.loadFromConfigValue(keybindConfiguration.cut);
        DUPLICATE.loadFromConfigValue(keybindConfiguration.duplicate);
        COPY.loadFromConfigValue(keybindConfiguration.copy);
        PASTE.loadFromConfigValue(keybindConfiguration.paste);
        SAVE_BLUEPRINT.loadFromConfigValue(keybindConfiguration.saveBlueprint);
        SHOW_SELECTION.loadFromConfigValue(keybindConfiguration.showSelection);
        SHOW_BIOMES.loadFromConfigValue(keybindConfiguration.showBiomes);
        QUICK_FILL.loadFromConfigValue(keybindConfiguration.quickFill);
        QUICK_REPLACE.loadFromConfigValue(keybindConfiguration.quickReplace);
        ROTATE_PLACEMENT.loadFromConfigValue(keybindConfiguration.rotatePlacement);
        FLIP_PLACEMENT.loadFromConfigValue(keybindConfiguration.flipPlacement);
        useVanillaMovement = keybindConfiguration.useVanillaMovement;
        MOVE_QUICK.loadFromConfigValue(keybindConfiguration.moveQuick);
        MOVE_FORWARD.loadFromConfigValue(keybindConfiguration.moveForward);
        MOVE_LEFT.loadFromConfigValue(keybindConfiguration.moveLeft);
        MOVE_BACKWARD.loadFromConfigValue(keybindConfiguration.moveBackward);
        MOVE_RIGHT.loadFromConfigValue(keybindConfiguration.moveRight);
        MOVE_UP.loadFromConfigValue(keybindConfiguration.moveUp);
        MOVE_DOWN.loadFromConfigValue(keybindConfiguration.moveDown);
        for (Map.Entry<String, String> entry : keybindConfiguration.toolKeybinds.entrySet()) {
            for (Keybind keybind : toolKeybinds.keybinds()) {
                if (!keybind.getDescriptionRaw().equals(entry.getKey())) continue;
                keybind.loadFromConfigValue(entry.getValue());
            }
        }
        COPY_INGAME.loadFromConfigValue(keybindConfiguration.copyIngame);
        NUDGE_UP.loadFromConfigValue(keybindConfiguration.nudgeUp);
        NUDGE_DOWN.loadFromConfigValue(keybindConfiguration.nudgeDown);
        NUDGE_LEFT.loadFromConfigValue(keybindConfiguration.nudgeLeft);
        NUDGE_RIGHT.loadFromConfigValue(keybindConfiguration.nudgeRight);
    }

    public static void saveToConfig(KeybindConfiguration keybindConfiguration) {
        keybindConfiguration.rotateCamera = ROTATE_CAMERA.toConfigValue();
        keybindConfiguration.pickBlock = PICK_BLOCK.toConfigValue();
        keybindConfiguration.useTool = USE_TOOL.toConfigValue();
        keybindConfiguration.arcballCamera = ARCBALL_CAMERA.toConfigValue();
        keybindConfiguration.arcballCardinalSnap = ARCBALL_CARDINAL_SNAP.toConfigValue();
        keybindConfiguration.panCamera = PAN_CAMERA.toConfigValue();
        keybindConfiguration.crosshairCamera = CROSSHAIR_CAMERA.toConfigValue();
        keybindConfiguration.adjustRadius = ADJUST_RADIUS.toConfigValue();
        keybindConfiguration.adjustSpeed = ADJUST_SPEED.toConfigValue();
        keybindConfiguration.undo = UNDO.toConfigValue();
        keybindConfiguration.redo = REDO.toConfigValue();
        keybindConfiguration.cut = CUT.toConfigValue();
        keybindConfiguration.duplicate = DUPLICATE.toConfigValue();
        keybindConfiguration.copy = COPY.toConfigValue();
        keybindConfiguration.paste = PASTE.toConfigValue();
        keybindConfiguration.saveBlueprint = SAVE_BLUEPRINT.toConfigValue();
        keybindConfiguration.showSelection = SHOW_SELECTION.toConfigValue();
        keybindConfiguration.showBiomes = SHOW_BIOMES.toConfigValue();
        keybindConfiguration.quickFill = QUICK_FILL.toConfigValue();
        keybindConfiguration.quickReplace = QUICK_REPLACE.toConfigValue();
        keybindConfiguration.rotatePlacement = ROTATE_PLACEMENT.toConfigValue();
        keybindConfiguration.flipPlacement = FLIP_PLACEMENT.toConfigValue();
        keybindConfiguration.useVanillaMovement = useVanillaMovement;
        keybindConfiguration.moveQuick = MOVE_QUICK.toConfigValue();
        keybindConfiguration.moveForward = MOVE_FORWARD.toConfigValue();
        keybindConfiguration.moveLeft = MOVE_LEFT.toConfigValue();
        keybindConfiguration.moveBackward = MOVE_BACKWARD.toConfigValue();
        keybindConfiguration.moveRight = MOVE_RIGHT.toConfigValue();
        keybindConfiguration.moveUp = MOVE_UP.toConfigValue();
        keybindConfiguration.moveDown = MOVE_DOWN.toConfigValue();
        for (Keybind keybind : toolKeybinds.keybinds()) {
            keybindConfiguration.toolKeybinds.put(keybind.getDescriptionRaw(), keybind.toConfigValue());
        }
        keybindConfiguration.copyIngame = COPY_INGAME.toConfigValue();
        keybindConfiguration.nudgeUp = NUDGE_UP.toConfigValue();
        keybindConfiguration.nudgeDown = NUDGE_DOWN.toConfigValue();
        keybindConfiguration.nudgeRight = NUDGE_RIGHT.toConfigValue();
        keybindConfiguration.nudgeLeft = NUDGE_LEFT.toConfigValue();
    }
}

